#! /usr/bin/env python1.5
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/CVS/gnuton/lib/GnutOS/Exceptions.py,v $
# Version:     $RCSfile: Exceptions.py,v $ $Revision: 1.1.1.1 $
# Copyright:   (C) 1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""

"""

#############################################################################

import string, sys


#############################################################################
#  Exception base class

__pyver = string.atof(sys.version[:3])

if __pyver < 1.5:
    class GnutOSException:
	"""An exception defined by the GnutOS software."""
	pass

else:
    class GnutOSException(Exception):
	"""An exception defined by the GnutOS software."""
	pass

#############################################################################

#fixme:  will need some thought here ...

class EvtExFrStore(GnutOSException):
    """Store-related exceptions."""
    pass

class ObsoleteMethod(GnutOSException):
    """This method is not supported in this OS version."""
    pass


class HM_Exception(GnutOSException):
    """HardwareManager errors."""
    pass

class HM_NoDriverForDeviceType(HM_Exception):
    """Cannot register the device because no driver exists for its type."""
    pass

class HM_DriverLoadError(HM_Exception):
    """Importing the driver class failed."""
    pass

class HM_DriverInstallError(HM_Exception):
    """The driver's install function failed."""
    pass

class HM_InvalidFileDevice(HM_Exception):
    """Could not create File device instance."""
    pass

class HM_DeviceError(HM_Exception):
    """General error with Device instance."""
    pass

class HM_DeviceParameterError(HM_Exception):
    """Parameters supplied to initialise a device were incorrect."""
    pass

class HM_NoSuchDriver(HM_Exception):
    """Driver name specified is not registered."""
    pass

class HM_NoSuchDevice(HM_Exception):
    """Device ID specified is not registered."""
    pass

class HM_DriverNotLocked(HM_Exception):
    """The specified driver was not locked using the supplied token."""
    pass



class BadSymbolString(GnutOSException):
    """The supplied string contained characters illegal in symbols."""
    pass


#############################################################################

if __name__ == "__main__":
    print "Testing Exceptions.py"
    print
    print "Done."


#############################################################################
