#! /usr/bin/env python1.5
#############################################################################
#
# Project:     GNUton
#
# File:        $Source: /home/arnold/CVS/gnuton/lib/GnutOS/Soup.py,v $
# Version:     $RCSfile: Soup.py,v $ $Revision: 1.1.1.1 $
# Copyright:   (C) 1998, David Arnold.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
"""

"""

#############################################################################

from   GnutOS.Classes      import Frame
from   GnutOS.Entry        import Entry


#############################################################################

class SoupOrUSoup:
    """Base class for all Soup and Union Soups."""

    def __init__(self):
	""" """

	self._name = ""
	self._uid = 0
	self._info = None
	self._sig = ""

	self._entries = []

	return

    def AddFlushedXmit(self, frameOrEntry, changeSym):
	return

    def AddIndexXmit(self, indexSpec, changeSym):

	if 0:
	    i_struct = f["structure"]
	    i_path = f["path"]
	    i_type = f["type"]

	pass

    def AddTagsXmit(self, tags, changeSym):
	return

    def GetName(self):
	return self._name

    def GetSize(self):
	return

    def ModifyTagXmit(self, oldTag, newTag, changeSym):
	return

    def RemoveTagsXmit(self, tags, changeSym):
	return

    def RemoveIndexXmit(self, indexPath, changeSym):
	"""Remove index from soup or union soup."""
	pass

    def Query(self, querySpec):
	return


    #-- obsolete methods

    def AddTags(self, tagsToAdd):
	raise ObsoleteMethod("use AddTagsXmit()")

    def RemoveTags(self, tagsToRemove):
	raise ObsoleteMethod("use RemoveTagsXmit()")


#############################################################################

class UnionSoup(SoupOrUSoup):

    def AddToDefaultStoreXmit(self, frame, changeSym):
	return

    def AddToStoreXmit(self, frame, store, changeSym):
	return

    def GetMember(self, store):
	"""Return reference to the member soup on the specified store."""
	return

    def GetSoupList(self):
	return


    #-- obsolete methods

    def AddToDefaultStore(self, frame):
	raise ObsoleteMethod("use AddToDefaultStoreXmit()")



#############################################################################

class Soup(SoupOrUSoup):
    """

    A NewtonScript soup is a storage facility for frames.  On a
    Newton device, the frames in a soup are acutally compressed until
    they are used, at which point they are decompressed and cached in
    RAM.

    Access to the frames in a soup is similar to a database - it is
    normally done by defining a query cursor using one of the index
    slots for the soup.

    """

    def __init__(self, ref_store):
	""" """

	SoupOrUSoup.__init__(self)
	self._store = ref_store

	return

    def AddWithUniqueIdXmit(self, entry, changeSym):
	return

    def AddXmit(self, frame, changeSym):
	return

    def CopyEntriesXmit(self, destSoup, changeSym):
	pass

    def Flush(self):
	pass

    def GetAllInfo(self):
	pass

    def GetIndexes(self):
	pass

    def GetIndexesModTime(self):
	return

    def GetInfo(self, slotSymbol):
	pass

    def GetInfoModTime(self):
	return

    def GetNextUid(self):
	return self._uid

    def GetSignature(self):
	return self._sig

    def GetStore(self):
	return self._store

    def GetTags():
	return

    def HasTags(self):
	return

    def IndexSizes(self):
	pass

    def IsValid(self):
	return

    def MakeKey(self, string, indexPath):
	return

    def RemoveAllEntriesXmit(self, changeSym):
	"""Remove all entries from soup."""
	return

    def RemoveFromStoreXmit(self, changeSym):
	"""Remove the soup object from its store."""

	#fixme: why is this a soup method?

	self._store.xxx(self)   #fixme!
	return

    def SetAllInfoXmit(self, frame, changeSym):
	"""Set the soup's info slot to the supplied frame."""

	self._info = frame    #fixme: copy? deepcopy?
	return

    def SetInfoXmit(self, slotSymbol, value, changeSym):
	"""Set the value of a slot in the soup's info frame."""

	if not self._info:
	    self._info = {}

	self._info[slotSymbol] = value
	return NIL

    def SetName(self, soupNameString):
	"""Set the name of the soup to the supplied string."""

	#-- check that name is not already in use
	if 0:
	    raise NameError

	self._name = soupNameString
	return self._name

    def SetSignature(self, signature):
	"""Set the soup signature to the specified integer."""

	self._sig = signature
	return self._sig


    #-- obsolete methods

    def Add(self, frame):
	raise ObsoleteMethod("use AddXmit()")

    def AddIndex(self, indexSpec):
	raise ObsoleteMethod("use AddIndexXmit()")

    def AddWithUniqueId(self, frame):
	raise ObsoleteMethod("use AddWithUniqueIdXmit")

    def RemoveAllEntries(self):
	raise ObsoleteMethod("use RemoveAllEntriesXmit()")

    def RemoveFromStore(self):
	raise ObsoleteMethod("use RemoveFromStoreXmit()")

    def SetAllInfo(self, frame):
	raise ObsoleteMethod("use SetAllInfoXmit()")

    def SetInfo(self, slotSymbol, value):
	raise ObsoleteMethod("use SetInfoXmit()")


#############################################################################
