//
//  Newton Connection Library - Newton/UNIX Connectivity
//  Copyright (C) 1995-1997  A. E. Hall
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the Free
//  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

char Inbox_C_rcsid[] = "$Id: Inbox.C,v 1.3 1997/08/24 21:38:02 spoonman Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <regex.h>
#include <SFile.h>
#include "Newton.H"

// The Newtl Inbox Processor!!!

enum process_type { INBOXnone, INBOXbeam, INBOXenhancement, INBOXemail };

// send the stuff to InfraRed!
int Newton::BeamInbox()
  {
  fprintf(stderr,"BEAM: Sorry, not yet implemented.\n");
  return(ProcessInbox(INBOXbeam));
  };

// send the stuff to Enhancement!
int Newton::EnhancementInbox()
  {
  fprintf(stderr,"ENHANCEMENT: Sorry, not yet implemented.\n");
  fprintf(stderr,"ENHANCEMENT: Um, by the way, what's an \"enhancement\"?\n");
  return(ProcessInbox(INBOXenhancement));
  };

// send the stuff to Email!
int Newton::EmailInbox()
  {
  return(ProcessInbox(INBOXemail));
  };

// Populate Newton's Inbox
int Newton::ProcessInbox(const int whichInbox)
  {
  Regex RXfrom("^From ");
  char inFileName[255];
  char *fileLine;
  String fileLineString, tmpFileName;
  SFile inFile, tmpFile;

  fprintf(stderr,"ProcessInbox: Still testing, sorry!\n");
  return(NewtonOK);


  switch(whichInbox)
    {
    case INBOXemail:
      sprintf(inFileName,"/var/spool/mail/%s",getenv("USER"));
      break;
    };

  tmpFileName = tmpnam(NULL);
  tmpFile.open(tmpFileName, 2048, ios::out);
  if (!tmpFile.is_open())
    {
    fprintf(stderr,"newtl: Cannot open tmp file: %s\n",tmpFileName.chars());
    return(NewtonERROR);
    };
  tmpFile.write("Inbox\n", 6);

  inFile.open(inFileName, 2048, ios::in);
  if (!inFile.is_open())
    {
    fprintf(stderr,"newtl: Cannot open file: %s\n",inFileName);
    return(NewtonERROR);
    };

  fileLine = new char[255]; 
  inFile.gets(&fileLine);

  while (fileLine != NULL)
    {
    fileLineString = fileLine;
    if (fileLineString.contains(RXfrom))
      {
      tmpFile.write(SlurpeeNoteDelim,strlen(SlurpeeNoteDelim));
      };
    fileLineString += "\n";
    tmpFile.write(fileLineString, fileLineString.length());
    inFile.gets(&fileLine);
    };

  delete [] fileLine; 
  inFile.close();
  tmpFile.close();


  return(NewtonOK);
  };

