#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# Get4KsendfaxPhonebook
#---------------------------------------------------------------------

# $Log: Get4KsendfaxPhonebook.pl,v $
# Revision 1.1  1998/09/02 13:54:31  kalli
# Initial revision
#

# format for Ksendfax phonebook file
format KSFAXFILE = 
@<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
$CardfaxPhone       $CardName                $Cardcompany
.


sub Get4KsendfaxPhonebook {

    # Get actual Newton cards
    &GetCards;

    # save old Ksendfax phonebook file
    if (-e "$KsendfaxPhonebookFile") {
	rename ("$KsendfaxPhonebookFile", "$KsendfaxPhonebookFile.bak");
    }
    
    # Open Newtonlink cards file
    open (NLCARDFILE, "$NLCardsFile")  || die "Can't open File : $!\n";

    # Open Ksendfax phonebook file
    open (KSFAXFILE, ">> $KsendfaxPhonebookFile")  || die "Can't open File : $!\n";
    
    # print to stdout
    printf "Writing Ksendfax phonebook file $KsendfaxPhonebookFile ...\n";
    
    while (<NLCARDFILE>) {

        ($Cardclass, $CardlastName, $CardfirstName, $Cardhonorific, $Cardaddress, $Cardcountry, $Cardpostal_code,
         $Cardcity, $Cardbday, $CardhomePhone, $CardworkPhone, $CardfaxPhone, $Cardemail, $Cardcompany) = split(/;/, $_, 20);

        if ( ($Cardclass eq "company") || ($Cardclass eq "person") || ($Cardclass eq "owner") ) {

            if ($CardfaxPhone ne "") {
                $CardName = "$CardlastName, ". "$CardfirstName";
                # delete special characters ()x
                $CardfaxPhone =~ s/\(/ /g;
                $CardfaxPhone =~ s/\)/ /g;
                $CardfaxPhone =~ s/x/ /g;
	        write KSFAXFILE;
            }
        }
    }
    
    # close files
    close (KSFAXFILE);
    close (NLCARDFILE);
}

1;
