#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1998    The Newtonlink Developers
#                            (newtonlink@newton.bawue.de)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# Get4NetscapeMail
#---------------------------------------------------------------------

# $Log: Get4NetscapeMail.pl,v $
# Revision 1.12  1998/03/07 13:25:53  kalli
# Umstellung auf neue ser. Treiber
#
# Revision 1.11  1997/12/06 17:13:24  kalli
# Umstellung auf Sloup
#
# Revision 1.10  1997/12/06 16:31:02  kalli
# Variable NewtonMailer nach Vorschlag von jack Snoeyink eingefuehrt
#
# Revision 1.9  1997/09/28 09:54:44  kalli
# Aenderung von Andrew :
# Select-Statement
#
# Revision 1.8  1997/05/28 19:14:49  kalli
# Aenderungen von Gerald Hofer fuer IRIX
#
# Revision 1.7  1997/03/27 19:36:42  kalli
# Andrew dazu
#
# Revision 1.6  1997/02/24 20:48:04  kalli
# Ausrufezeichen in Email-Adressen
#
# Revision 1.5  1997/02/23 14:58:18  kalli
# Ausgabe von Debuginfos raus
#
# Revision 1.4  1997/02/23 12:50:06  kalli
# Bugfixes, Umlaute werden nach ae, oe ... gewandelt
#
# Revision 1.3  1997/02/22 16:49:26  kalli
# Umstellung auf mehrfache TO, CC, und BCC Eintraege
#
# Revision 1.2  1996/12/04 17:39:31  kalli
# some bugs fixed
#
# Revision 1.1  1996/11/24 19:43:30  kalli
# Initial revision
#

sub Get4NetscapeMail {

    select((select(STDOUT), $|=1)[$[]);
    
    # start counter
    $NetscapeEmailCounter = 0;
    # set marker
    $MailOn = "off";

    # Open file
    open (NSFILE, ">> $NetscapeOutboxFile")  || die "Can't open File : $!\n";

    # send commands to Sloup (get "to" entries)
    &send_line (COMNEWTON, "\nOutbox");
    &send_line (COMNEWTON, '{state: "string", category: "string",' .
                           'toRef: [{email: "binary", name: {first: "string", last: "string"}}]}'); 
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \";\"}");

    # reset message counter
    $MessCount = 0;

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace German Umlaute
	s/\232/oe/g; s/\212/ae/g; s/\237/ue/g; s/\247/ss/g; s/\205/Oe/g; s/\200/Ae/g; s/\206/Ue/g;
	# split into
	@Arrr = split(/;/, $_);

	# if new outbox entry
	if (($Arrr[0] eq "ready") && ($Arrr[1] eq $NewtonMailer)) {
	    #print;

	    # calculate number of to-entries
	    $ToCount[$MessCount] = ((scalar @Arrr) - 3) / 3;

	    # create string
	    $ToString[$MessCount] =  "To: ";	    
	    for ($ri = 0; $ri < $ToCount[$MessCount]; $ri++) {
		$ToString[$MessCount] = "$ToString[$MessCount]".",\n" if ($ri > 0); 
	        $ToString[$MessCount] = "$ToString[$MessCount]"." \""."$Arrr[($ri*3)+2+2]"." "."$Arrr[($ri*3)+1+2]"."\" "."<$Arrr[($ri*3)+2]>";
	    }

	    # Print sign to stdout
	    print ".";
	    #print "Message contains $ToCount[$MessCount] TO-entries :\n";
	    #print "$ToString[$MessCount]\n";
	    $MessCount++;
        }
    }

    if ($SystemType eq "IRIX") {
        close COMNEWTON;
        open (COMNEWTON, "+>$tty");
        &SetSloupBaudrate;
        printf (COMNEWTON "\n");
    }


    # send commands to Sloup (get "cc" entries)
    &send_line (COMNEWTON, "Outbox");
    &send_line (COMNEWTON, '{state: "string", category: "string",' .
                           'cc: [{email: "binary", name: {first: "string", last: "string"}}]}'); 
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \";\"}");

    # reset message counter
    $MessCount = 0;

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace German Umlaute
	s/\232/oe/g; s/\212/ae/g; s/\237/ue/g; s/\247/ss/g; s/\205/Oe/g; s/\200/Ae/g; s/\206/Ue/g;
	# split into
	@Arrr = split(/;/, $_);

	# if new outbox entry
	if (($Arrr[0] eq "ready") && ($Arrr[1] eq $NewtonMailer)) {
	    #print;

	    # calculate number of cc-entries
	    $CCCount[$MessCount] = ((scalar @Arrr) - 3) / 3;

	    # create string
	    $CCString[$MessCount] =  "CC: ";	    
	    for ($ri = 0; $ri < $CCCount[$MessCount]; $ri++) {
		if( ($ri == 0 ) && (length( $Arrr[($ri*3)+2]) > 0)) {
                    $CCString[$MessCount] =  "CC: ";
                }
		if( length( $Arrr[($ri*3)+2]) > 0) {
		    $CCString[$MessCount] = "$CCString[$MessCount]".",\n" if ($ri > 0); 
		    $CCString[$MessCount] = "$CCString[$MessCount]"." \""."$Arrr[($ri*3)+2+2]"." "."$Arrr[($ri*3)+1+2]"."\" "."<$Arrr[($ri*3)+2]>";
                } 
	    }

	    # Print sign to stdout
	    print ".";
	    #print "Message contains $CCCount[$MessCount] CC-entries :\n";
	    #print "$CCString[$MessCount]\n";
	    $MessCount++;
        }
    }

    if ($SystemType eq "IRIX") {
        close COMNEWTON;
        open (COMNEWTON, "+>$tty");
        &SetSloupBaudrate;
        printf (COMNEWTON "\n");
    }

    # send commands to Sloup (get "bcc" entries)
    &send_line (COMNEWTON, "Outbox");
    &send_line (COMNEWTON, '{state: "string", category: "string",' .
                           'bcc: [{email: "binary", name: {first: "string", last: "string"}}]}'); 
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \";\"}");

    # reset message counter
    $MessCount = 0;

    while (($_ = &receive_line (COMNEWTON)) ne "BYE!") {

	# replace German Umlaute
	s/\232/oe/g; s/\212/ae/g; s/\237/ue/g; s/\247/ss/g; s/\205/Oe/g; s/\200/Ae/g; s/\206/Ue/g;
	# split into
	@Arrr = split(/;/, $_);

	# if new outbox entry
	if (($Arrr[0] eq "ready") && ($Arrr[1] eq $NewtonMailer)) {

	    # calculate number of cc-entries
	    $BCCCount[$MessCount] = ((scalar @Arrr) - 3) / 3;

	    # create string
	    $BCCString[$MessCount] =  "BCC: ";	    
	    for ($ri = 0; $ri < $BCCCount[$MessCount]; $ri++) {
		if( ($ri == 0 ) && (length( $Arrr[($ri*3)+2]) > 0)) {
                    $BCCString[$MessCount] =  "BCC: ";
                }
		if( length( $Arrr[($ri*3)+2]) > 0) {
		    $BCCString[$MessCount] = "$BCCString[$MessCount]".",\n" if ($ri > 0); 
		    $BCCString[$MessCount] = "$BCCString[$MessCount]"." \""."$Arrr[($ri*3)+2+2]"." "."$Arrr[($ri*3)+1+2]"."\" "."<$Arrr[($ri*3)+2]>"; 
		}
	    }

	    # Print sign to stdout
	    print ".";
	    #print "Message contains $BCCCount[$MessCount] BCC-entries :\n";
	    #print "$BCCString[$MessCount]\n";
	    $MessCount++;
        }
    }

    if ($SystemType eq "IRIX") {
        close COMNEWTON;
        open (COMNEWTON, "+>$tty");
        &SetSloupBaudrate;
        printf (COMNEWTON "\n");
    }

    
    # send commands to Sloup
    &send_line (COMNEWTON, "Outbox");
    &send_line (COMNEWTON, '{state: "string", category: "string", title: "string", dateStr: "string",' .
                           'fromName: "string", text: "string"}'); 
    &send_line (COMNEWTON, "DUMP!{fieldDelimiter: \"\t\"}");

    # reset message counter
    $MessCount = 0;

    while (($_ = &receive_line(COMNEWTON)) ne "BYE!") {

	# replace German Umlaute
	s/\232/oe/g; s/\212/ae/g; s/\237/ue/g; s/\247/ss/g; s/\205/Oe/g; s/\200/Ae/g; s/\206/Ue/g;
	# split into
	($Estate, $Ecategory, $Etitle, $EdateStr, $EfromName, $Ebody) = split(/\t/, $_, 20);

	# if new outbox entry
	if (defined ($Estate) && ($Estate eq "ready")) {

	    if (defined ($Ecategory) && ($Ecategory eq $NewtonMailer)) {

		# set marker
		$MailOn = "on";
		# print to file
		printf NSFILE "From - $EdateStr\n";
		printf NSFILE "X-Mozilla-Status: 0801\n";
		printf NSFILE "FCC: /home/e1l52/nsmail/Sent\n";
		printf NSFILE "$BCCString[$MessCount]\n";
		printf NSFILE "Message-ID: <>\n";
		printf NSFILE "Date: $EdateStr\n";
		printf NSFILE "From: $EfromName \<$YourEmailAddress\>\n";
		printf NSFILE "Reply-To: $EfromName \<$YourEmailAddress\>\n";
		printf NSFILE "Organization: $YourOrganisation\n";
		printf NSFILE "X-Mailer: Newton eWorld mail (via Newtonlink)\n";
		printf NSFILE "MIME-Version: 1.0\n";
		printf NSFILE "$ToString[$MessCount]\n";
		printf NSFILE "$CCString[$MessCount]\n";
		printf NSFILE "Subject: $Etitle\n";
		printf NSFILE "Content-Type: text/plain; charset=us-ascii\n";
		printf NSFILE "Content-Transfer-Encoding: 7bit\n\n";
		printf NSFILE "\n$Ebody\n";

		$MessCount++;
		# Print sign to stdout
		print "#";
		$NetscapeEmailCounter++;
	
	    } else {
		# reset marker
		$MailOn = "off";
	    }

	# if not new outbox entry
	} elsif ($MailOn eq "on") {
	    print NSFILE "$_\n";
	}

    }

    # close file
    close (NSFILE);
    # print to stdout
    print ("\n$NetscapeEmailCounter eWorld emails transfered");
}

1;
