#=======================================================================
# Newtonlink   - transfer data between a Apple Newton Message Pad and
#                Unix applications
#
# Copyright (C) 1996-1997 Reinhold Schoeb (schoeba@str.daimler-benz.com)
#                         Frank Scholz (dev@artus.pf.bawue.de)
#                         Andrew Maier (Andrew.Maier@cern.ch)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#=======================================================================

#---------------------------------------------------------------------
# finesse_gui
#---------------------------------------------------------------------

# $Log: finesse_gui.pl,v $
# Revision 1.7  1997/03/27 19:50:07  kalli
# Andrew dazu
#
# Revision 1.6  1997/03/06 18:55:13  kalli
# Umstellung auf Version 1.0
#
# Revision 1.5  1997/02/24 20:48:44  kalli
# Modul mail dazu
#
# Revision 1.4  1997/02/23 15:17:07  kalli
# Frank dazu
#
# Revision 1.3  1997/02/22 17:06:13  kalli
# GPL dazu
#
# Revision 1.2  1997/01/05 16:06:09  kalli
# Newton device open vor jedem UP-Aufruf
#
# Revision 1.1  1996/12/04 17:42:19  kalli
# Initial revision
#

# Finesse window declarations
$ShowWindow = "FsWindow -name ShowWindow -title 'newtonlink $rev';
               FsPushButton     -label addressbook     -name AdrButton    -fsbutton AdrButton    -winstat touch -nrows 3;
               FsPushButton     -label Xrolodex        -name XroloButton  -fsbutton XroloButton  -winstat touch;
               FsPushButton     -label Plan            -name PlanButton   -fsbutton PlanButton   -winstat touch;
               FsPushButton     -label Print           -name PrintButton  -fsbutton PrintButton  -winstat touch;
               FsPushButton     -label Fax             -name FaxButton    -fsbutton FaxButton    -winstat touch;
               FsPushButton     -label Netscape        -name NetscButton  -fsbutton NetscButton  -winstat touch;
               FsPushButton     -label NetscAdr        -name NetscAButton -fsbutton NetscAButton -winstat touch;
               FsPushButton     -label Mail            -name MailButton   -fsbutton MailButton   -winstat touch;
               FsPushButton     -label Install         -name InstButton   -fsbutton InstButton   -winstat touch;
               FsPushButton     -label Input           -name InputButton  -fsbutton InputButton  -winstat touch;
               FsPushButton     -label Send            -name SendButton   -fsbutton SendButton   -winstat touch;
               FsPushButton     -label Help            -name HelpButton   -fsbutton HelpButton   -winstat touch;
               FsPushButton     -label Exit            -name ExitButton   -fsbutton ExitButton   -winstat close;
               FsSelectionText  -label File            -var  GUIfilename;
               FsCheck          -name  PrintCk         -var  PrintFsCh    -items Ghostview;
               FsSeparator;
               FsLabel          -label 'Make sure Slurpee is running on your Newton';
              ";

sub finesse_gui {

    # Finesse perl script initialization
    $ENV{'FINESSEPATH'} = '/usr/local/finesse' if !$ENV{'FINESSEPATH'};

    if (!-x "$ENV{'FINESSEPATH'}/fsperlinit") {
	printf "Finesse lib missing, X-windows mode not available, use command line mode" ;
	# close connection
	close COMNEWTON;
	printf "\nNewton connection closed\n";
	exit;
    }

    require("$ENV{'FINESSEPATH'}/fsperlinit");

    # Set up finesse application server
    &Fsopen("-o 1", @ARGV);

    # finesse main loop
    for (;;) {

	# Show finesse window
	&Fsdisplay ("-w", $ShowWindow, "-n", "ShowWindow", "-s", "input");

	if ($fsbutton eq "ExitButton") {
	    #Terminate finesse application server
	    &Fsclose;
	    # Terminate program
	    exit;

	} elsif ($fsbutton eq "HelpButton") {
	    system "netscape -remote 'openFile(/usr/local/newtonlink/doc/newtonlink-doc-en.html)' || netscape /usr/local/newtonlink/doc/newtonlink-doc-en.html &";

	} elsif ($fsbutton eq "FaxButton") {
	    printf "Sorry, option currently not available\n";

	} elsif ($fsbutton eq "InstButton") {

	    # get filename from window
	    $PackageFile = $GUIfilename;
	    if ($PackageFile eq "") {
		printf "Exit - file name missing\n";
		exit;
	    } else {
		# set new baudrate
		printf "Switch baudrate to $SlurpeeBaudrate\n";
		&SetSlurpeeBaudrate;
		if (open (COMNEWTON, "+>$tty")) {
		    printf "Newton connection opened\n";
		} else {
		    print STDERR "Can't open $tty\n";
		    exit;
		}
		printf "Install Newton package $PackageFile\n";
		# install Newton package
		&InstallPackage;
		# close connection
		close COMNEWTON;
		printf "\nNewton connection closed\n";
	    }

	} elsif ($fsbutton eq "InputButton") {
	    printf "Sorry, option only available in command line mode\n";

	} elsif ($fsbutton eq "AdrButton") {
	    # set new baudrate
	    printf "Switch baudrate to $SlurpeeBaudrate\n";
	    &SetSlurpeeBaudrate;
	    if (open (COMNEWTON, "+>$tty")) {
		printf "Newton connection opened\n";
	    } else {
		print STDERR "Can't open $tty\n";
		exit;
	    }
	    # get cards from Newton
	    &Get4Addressbook;
	    # call addressbook
	    system "$AddressbookCommand &";
	    # close connection
	    close COMNEWTON;
	    printf "\nNewton connection closed\n";

	} elsif ($fsbutton eq "PlanButton") {
	    # set new baudrate
	    printf "Switch baudrate to $SlurpeeBaudrate\n";
	    &SetSlurpeeBaudrate;
	    if (open (COMNEWTON, "+>$tty")) {
		printf "Newton connection opened\n";
	    } else {
		print STDERR "Can't open $tty\n";
		exit;
	    }
	    # get dates from Newton
	    &GetMeetings4Plan;
	    # call plan
	    system "$PlanCommand &";
	    # close connection
	    close COMNEWTON;
	    printf "\nNewton connection closed\n";

	} elsif ($fsbutton eq "PrintButton") {
	    # set new baudrate
	    printf "Switch baudrate to $SlurpeeBaudrate\n";
	    &SetSlurpeeBaudrate;
	    if (open (COMNEWTON, "+>$tty")) {
		printf "Newton connection opened\n";
	    } else {
		print STDERR "Can't open $tty\n";
		exit;
	    }
	    if ($GUIfilename eq "") {
		$PrintFile = $PrintDefaultFile;
	    } else {
		# get filename from window
		$PrintFile = $GUIfilename;
	    }
	    # do a printout ?
	    if ($PrintFsCh eq "Ghostview") {
		$printmode = "on";
	    } else {
		$printmode = "off";
	    }
	    # get outbox from Newton
	    &GetPrintOutbox;
	    # do a printout
	    if ($printmode eq "on") {
		system "$GhostviewCommand -landscape $PrintFile.ps";
	    }
	    # close connection
	    close COMNEWTON;
	    printf "\nNewton connection closed\n";

	} elsif ($fsbutton eq "NetscButton") {
	    # set new baudrate
	    printf "Switch baudrate to $SlurpeeBaudrate\n";
	    &SetSlurpeeBaudrate;
	    if (open (COMNEWTON, "+>$tty")) {
		printf "Newton connection opened\n";
	    } else {
		print STDERR "Can't open $tty\n";
		exit;
	    }
	    # get outbox from Newton
	    &Get4NetscapeMail;
	    # close connection
	    close COMNEWTON;
	    printf "\nNewton connection closed\n";

	} elsif ($fsbutton eq "NetscAButton") {
	    # set new baudrate
	    printf "Switch baudrate to $SlurpeeBaudrate\n";
	    &SetSlurpeeBaudrate;
	    if (open (COMNEWTON, "+>$tty")) {
		printf "Newton connection opened\n";
	    } else {
		print STDERR "Can't open $tty\n";
		exit;
	    }
	    # get cards from Newton
	    &Get4NetscapeAddressbook;
	    # close connection
	    close COMNEWTON;
	    printf "\nNewton connection closed\n";

	} elsif ($fsbutton eq "MailButton") {
	    # set new baudrate
	    printf "Switch baudrate to $SlurpeeBaudrate\n";
	    &SetSlurpeeBaudrate;
	    if (open (COMNEWTON, "+>$tty")) {
		printf "Newton connection opened\n";
	    } else {
		print STDERR "Can't open $tty\n";
		exit;
	    }
	    # get eWorld mail from Newton
	    &Get4Mail;
	    # close connection
	    close COMNEWTON;
	    printf "\nNewton connection closed\n";

	} elsif ($fsbutton eq "SendButton") {

	    # get filename from window
	    $SendFile = $GUIfilename;
	    if ($SendFile eq "") {
		printf "Exit - file name missing\n";
		exit;
	    } else {
		# set new baudrate
		printf "Switch baudrate to $SlurpeeBaudrate\n";
		&SetSlurpeeBaudrate;
		if (open (COMNEWTON, "+>$tty")) {
		    printf "Newton connection opened\n";
		} else {
		    print STDERR "Can't open $tty\n";
		    exit;
		}
		printf "Send file $SendFile to Newton PDA\n";
		# send file to Newton
		&SendFile2Newton;
		# close connection
		close COMNEWTON;
		printf "\nNewton connection closed\n";
	    }

	} elsif ($fsbutton eq "XroloButton") {
	    # set new baudrate
	    printf "Switch baudrate to $SlurpeeBaudrate\n";
	    &SetSlurpeeBaudrate;
	    if (open (COMNEWTON, "+>$tty")) {
		printf "Newton connection opened\n";
	    } else {
		print STDERR "Can't open $tty\n";
		exit;
	    }
	    if ($GUIfilename eq "") {
		$XrolodexFile = $XrolodexDefaultFile;
	    } else {
		# get filename from window
		$XrolodexFile = $GUIfilename;
	    }
	    # do a printout ?
	    if ($PrintFsCh eq "Ghostview") {
		$printmode = "on";
	    } else {
		$printmode = "off";
	    }
	    # get notes from Newton
	    &Get4Xrolodex;
	    # call xrolodex
	    system "$XrolodexCommand $XrolodexFile &";
	    # do a printout
	    if ($printmode eq "on") {
		system "$GhostviewCommand $XroloPrintFile.ps";
	    }
	    # close connection
	    close COMNEWTON;
	    printf "\nNewton connection closed\n";
	}
    }
}

1;





